' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports Microsoft.VisualBasic

Public Class AppConfiguration

  ''' <summary>
  ''' Ukryj konstruktor, aby unikn tworzenia egzemplarzy klasy AppConfiguration class.
  ''' </summary>
  Private Sub New()
  End Sub

  ''' <summary>
  ''' Zwraca instancj domylnego ustawienia ConnectionStringSettings, zpaewniajc dostp do waciwoci ConnectionString i ProviderName biecego poczenia.
  ''' </summary>
  Public Shared ReadOnly Property ConnectionStringSettings() As ConnectionStringSettings
    Get
      Dim connectionStringKey As String = _
          ConfigurationManager.AppSettings.Get("DefaultConnectionString")
      Return ConfigurationManager.ConnectionStrings(connectionStringKey)
    End Get
  End Property

  ''' <summary>
  ''' Zwraca adres e-mail uywany do wysyania wiadomoci z tej witryny.
  ''' </summary>
  Public Shared ReadOnly Property EmailFrom() As String
    Get
      Try
        Return ConfigurationManager.AppSettings.Get("EmailFrom")
      Catch ex As Exception
        Return "Ty@TwojDostawca.Pl"
      End Try
    End Get
  End Property

  ''' <summary>
  ''' Zwraca adres e-mail, na ktry s wysyane komunikatyo bedach w obrbie witryny.
  ''' </summary>
  Public Shared ReadOnly Property EmailTo() As String
    Get
      Try
        Return ConfigurationManager.AppSettings.Get("EmailTo")
      Catch ex As Exception
        Return "Ty@TwojDostawca.Pl"
      End Try
    End Get
  End Property

End Class
